% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Learners.R
\name{learnDiagGaussian}
\alias{learnDiagGaussian}
\alias{learnPoisson}
\alias{learnGamma}
\alias{learnCategorical}
\title{Create an instance of a learn mixture model}
\usage{
learnDiagGaussian(
  data,
  labels,
  prop = NULL,
  models = clusterDiagGaussianNames(prop = "equal"),
  algo = "simul",
  nbIter = 100,
  epsilon = 1e-08,
  criterion = "ICL",
  nbCore = 1
)

learnPoisson(
  data,
  labels,
  prop = NULL,
  models = clusterPoissonNames(prop = "equal"),
  algo = "simul",
  nbIter = 100,
  epsilon = 1e-08,
  criterion = "ICL",
  nbCore = 1
)

learnGamma(
  data,
  labels,
  prop = NULL,
  models = clusterGammaNames(prop = "equal"),
  algo = "simul",
  nbIter = 100,
  epsilon = 1e-08,
  criterion = "ICL",
  nbCore = 1
)

learnCategorical(
  data,
  labels,
  prop = NULL,
  models = clusterCategoricalNames(prop = "equal"),
  algo = "simul",
  nbIter = 100,
  epsilon = 1e-08,
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{data}{frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables. If the data set contains NA values, they
will be estimated during the estimation process.}

\item{labels}{vector or factors giving the label class.}

\item{prop}{[\code{\link{vector}}] with the proportions of each class.
If NULL the proportions will be estimated using the labels.}

\item{models}{[\code{\link{vector}}] of model names to run. By default all
models are estimated.}

\item{algo}{character defining the algo to used in order to learn the model.
Possible values: "simul" (default), "impute" (faster but can produce biased results).}

\item{nbIter}{integer giving the number of iterations to do.
algo is "impute" this is the maximal authorized number of iterations. Default is 100.}

\item{epsilon}{real giving the variation of the log-likelihood for stopping the
iterations. Not used if algo is "simul". Default value is 1e-08.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of a learned mixture model class.
}
\description{
This function learn the optimal mixture model when the class labels are known
according to the \code{criterion} among the list of model given in \code{models}.
}
\examples{

## A quantitative example with the famous iris data set
data(iris)

## get data and target
x <- as.matrix(iris[,1:4]);
z <- as.vector(iris[,5]);
n <- nrow(x); p <- ncol(x);

## add missing values at random
indexes <- matrix(c(round(runif(5,1,n)), round(runif(5,1,p))), ncol=2);
x[indexes] <- NA;

## learn model
model <- learnDiagGaussian( data=x, labels= z, prop = c(1/3,1/3,1/3)
                          , models = clusterDiagGaussianNames(prop = "equal")
                          )

## get summary
summary(model)

## use graphics functions
\dontrun{
plot(model)
}
## print model
\dontrun{
print(model)
}

## get estimated missing values
missingValues(model)

}
\author{
Serge Iovleff
}
