% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smnr.R
\name{backfitglobal}
\alias{backfitglobal}
\title{Semiparametric Mixtures of Nonparametric Regressions with Global EM-type Algorithm}
\usage{
backfitglobal(x, y, u = NULL, h = NULL, ini = NULL, true = NULL)
}
\arguments{
\item{x}{independent variable x}

\item{y}{dependent variable y}

\item{u}{vector of grid points}

\item{h}{bandwidth for nonparametric regression; If NULL, will be calculated by reliable
and extremely fast kernel density estimator for one-dimensional data (ref: Z.I.Botev,J.F.Grotowski and D.P.Kroese,"KERNEL DENSITY ESTIMATION VIA DIFFUSION" ,Submitted to the Annals of Statistics, 2009)}

\item{ini}{initial values of parameters;ini=list(est_p=est_p,est_mu=est_mu,est_var=est_var); If NULL, estimated automatically by regression spline approximation.}

\item{true}{true value of the parameters; \cr true=list(true_p=true_p,true_mu=true_mu,true_var=true_var); See details.}
}
\value{
est_p: estimated proportions; est_mu: estimated mean functions,est_mu_u: estimated mean functions with linear interpolating,est_var: estimated variance,lh:likelihood;
initialtrue:which estimation was returned: see details.
}
\description{
A new class of semiparametric mixture of regression models,
where the mixing proportions and variances are constants,but the component regression functions are smooth functions of a covariate.
A onestep backfitting estimate and global EM-type algorithms have been proposed to achieve
the optimal convergence rate for both the global parameters and the nonparametric regression functions.
}
\details{
True parameter: If specified, likelihood of the estimated parameters will be calculated and compare
with likelihood calculated from initial value. If likelihood from true value is greater than that from the initial values
then return estimations from true value with initialtrue=1, otherwise return estimations from initial values with initialtrue=0.
}
\examples{
#produce data that matches the description using gen_mixreg function
#true_mu=c(4-sin(2*pi*x),1.5+cos(3*pi*x))
n=100;
u=seq(from=0,to=1,length=100);
true_p=c(0.3,0.7);
true_var=c(0.09,0.16);
out=gen_mixreg(n,true_p[1],true_var,u);

x=out$x;
y=out$y;
true_mu=out$true_mu;
true=list(true_p=true_p,true_mu=true_mu,true_var=true_var)

#estimate parameters using backfitglobal function.
esttrue=backfitglobal(x,y,u,h=0.08,true=true)
est=backfitglobal(x,y,u,h=NULL)
}
