% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{complhfrequency}
\alias{complhfrequency}
\title{Complete Likelihood Frequency Method for Label Switching}
\usage{
complhfrequency(est, lat)
}
\arguments{
\item{est}{Records the MLE and the estimated classification probabilities, can
be derived by the function: est=mixnorm(x,2,ini).}

\item{lat}{The latent component labels for all observations, a m by n 0-1 matrix
if (i,j)th cell is 1, then jth observation is from ith component.}
}
\value{
The estimation by complete posterior distribution
the result vector consist of mu of first dimension of first component, second component...,
mu of second dimension of first component, second component ...
pi of first component , second component ...
}
\description{
Solving the label switching problem by maximizing the complete likelihood.
}
\examples{

#Example1 : Mixture of Two Univariate Normal

#Simulate the data
n=200;prop=0.3;mudif=1.5;
n1=rbinom(1,n,prop);
x1=rnorm(n1,0,1);x2=rnorm(n-n1,mudif,1);
x=c(x1,x2);
pm=c(2,1,3,5,4);

#Use mixnorm to get MLE and the estimated classification probabilities
out=mixnorm(x,2);

#Prepare latent component label
lat=rbind(cbind(matrix(rep(1,n1),nrow=1),matrix(rep(0,n-n1),nrow=1)),
cbind(matrix(rep(0,n1),nrow=1),matrix(rep(1,n-n1),nrow=1)));

#Fit the complhfrequency/ distlatfrequency function
clhest=complhfrequency(out,lat);
ditlatest=distlatfrequency(out,lat);

#Order constraint labeling based on mu
est=c(out$mu,out$sigma[1],out$pi);
if(est[1]<est[2]){
 ordmuest=est;
}else{
 ordmuest=est[pm];
 }

#Order constraint labeling based on pi
if(est[4]<est[5]){
 ordpiest=est;
  }else{
 ordpiest=est[pm];
 }

#Example 2: Mixture of Two Multivariate Normal

#Simulate the data
 mu1=0.5;mu2=0.5;
 prop=0.3;
 n=400;n1=rbinom(1,n,prop);
 pm=c(2,1,4,3,6,5);
 sigma=diag(c(1,1));mu=matrix(c(0,mu1,0,mu2),ncol=2);pi=c(prop,1-prop);
 ini=list(sigma=sigma,mu=mu,pi=pi)
 x1=mvtnorm::rmvnorm(n1,c(0,0),ini$sigma);x2=mvtnorm::rmvnorm(n-n1,c(mu1,mu2),ini$sigma);
 x=rbind(x1,x2);

#Use mixnorm to get MLE and the estimated classification probabilities
 out=mixmnorm(x,2,1,ini);

#Prepare latent component label
 lat=rbind(cbind(matrix(rep(1,n1),nrow=1),matrix(rep(0,n-n1),nrow=1)),
 cbind(matrix(rep(0,n1),nrow=1),matrix(rep(1,n-n1),nrow=1)));

#Fit the complhfrequency/ distlatfrequency function
 clhest=complhfrequency(out,lat);
 distlatest=distlatfrequency(out,lat);

#Order constraint labeling based on mu1 or mu2
 est=c(out$mu[,1],out$mu[,2],out$pi,out$sigma[1,1],
 out$sigma[2,1],out$sigma[2,2]);
 if(est[1]<est[2]){
 ordmu1est=est[1:6];
 }else{
 ordmu1est=est[pm];
 }
 if(est[3]<est[4]){
  ordmu2est=est[1:6];
 }else{
  ordmu2est=est[pm];
 }

#Order constraint labeling based on pi
 if(est[5]<est[6]){
  ordpiest=est[1:6];
 }else{
  ordpiest=est[pm];
  }


#Example 3 Mixture of Three Multivariate Normal

#Simulate the data
mu1=1;mu2=1;
prop=c(0.2,0.3,0.5);n=100;m=3;
sigma=diag(c(1,1));mu=matrix(c(0,mu1,2*mu1,0,mu2,2*mu2),ncol=2);pi=prop;
ini=list(sigma=sigma,mu=mu,pi=pi)
u=runif(n,0,1);n1=sum(u<prop[1]);n3=sum(u>(prop[1]+prop[2]));n2=n-n1-n3;
x1=mvtnorm::rmvnorm(n1,c(0,0),ini$sigma);
x2=mvtnorm::rmvnorm(n2,c(mu1,mu2),ini$sigma);
x3=mvtnorm::rmvnorm(n3,c(2*mu1,2*mu2),ini$sigma);
x=rbind(x1,x2,x3);

#Use mixnorm to get MLE and the estimated classification probabilities
out=mixmnorm(x,m,1,ini);

#Prepare latent component label
lat=rbind(cbind(matrix(rep(1,n1),nrow=1),matrix(rep(0,n-n1),nrow=1)),
cbind(matrix(rep(0,n1),nrow=1),matrix(rep(1,n2),nrow=1),matrix(rep(0,n3),nrow=1)),
cbind(matrix(rep(0,n-n3),nrow=1),matrix(rep(1,n3),nrow=1)));

#Fit the complhfrequency/ distlatfrequency function
clhest=complhfrequency(out,lat);
distlatest=distlatfrequency(out,lat);

#Order constraint labeling based on mu1 or mu2
est=c(out$mu[,1],out$mu[,2],out$pi);
b=sort(est[1:3],index.return = TRUE)$ix; pm=c(b,b+3,b+6);
ordmu1est=est[pm];
b=sort(est[4:6],index.return = TRUE)$ix; pm=c(b,b+3,b+6);
ordmu2est=est[pm];

#Order constraint labeling based on pi
b=sort(est[7:9],index.return = TRUE)$ix; pm=c(b,b+3,b+6);
ordpiest=est[pm];

}
