% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{mixlint}
\alias{mixlint}
\title{Robust Mixture Regression Based on T-distribution}
\usage{
mixlint(x, y, m = 2, maxv = 30, numini = 20, acc = 10^(-5))
}
\arguments{
\item{x}{explanatory variables matrix with rows for each observation}

\item{y}{response variable vector}

\item{m}{number of component, default is 2}

\item{maxv}{maximum degree of freedom default is 30}

\item{numini}{number of initial value use to estimate the parameter, default is 20}

\item{acc}{stopping criteria, default is 10^(-5)}
}
\value{
theta: estimated parameters beta(intercept, slopes), sigma, proportion for each component
likelihood: likelihood of the estimated parameter
dif:  difference of likelihood of last iteration and second to last iteration
run: number of iteration to converge
vdegree: estimated degree of the t distribution
degreerange: all degree of freedom use to estimate the parameters
vlikelihoodseq: all likelihood associated with degrees of freedom
lh: likelihood list for all initial values
}
\description{
mixlint  adaptively estimates the mixture regression parameters robustly assuming the error distribution is t-distribution
}
\examples{
library(fpc)
data('tonedata')
y=tonedata$tuned
x=tonedata$stretchratio
k=160;x[151:k]=0;y[151:k]=5
\donttest{est_t=mixlint(x,y,2,numini=20,acc=0.1);}

}
