% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mphd.R
\name{mphd}
\alias{mphd}
\title{Minimum profile Hellinger distance estimation for a semiparametric mixture model}
\usage{
mphd(x, sigma = NULL, ini = NULL, true = NULL)
}
\arguments{
\item{x}{vector of observations}

\item{sigma}{sd of the known component; Can be set as NULL if the parameter is unknown.}

\item{ini}{initial values of parameters of components.  Format: list(mu,pi,sigma)
If ini is not specified, the function will derive initial values from x with equal
unknown variance normal mixture assumption.}

\item{true}{if the sigma is known: true = list(p,mu); if the sigma is unknown true =list(p,sigma,mu)}
}
\value{
list of estimations:  numiter: number of iteration
initialtrue: If the true value specified by the user fits the simulated data better return 1, 0 o.w.;
For below parameters, the returned value is based on initialtrue. If initialtrue = 1 return true parameters specified by the user,
if initialtrue=0 return estimated parameters:
sigma:estimated sigma when sigma is unknown;pi: estimated proportion; mu: estimated mean;
}
\description{
A effective estimator for a class of semiparametric mixture models where one component has known distribution
with possibly unknown parameters while the other component density and the mixing proportion are unknown.
The proposed estimator is based on the minimum profile Hellinger distance (MPHD).
}
\examples{

#Model: X-0.3N(0,1)+0.7N(3,1)
set.seed(4)
n=100;sigma2=1;p=0.3;mu=1.5;sigma=1;k=2;n1=rbinom(1,n,p);
x1=rnorm(sum(n1),0,sigma);x2=rnorm(n-sum(n1),mu,sigma2);x=c(x1,x2);

true=c(p,mu);
temp=mixonekn(x,sigma);
mphdest=mphd(x,sigma,ini = temp,true = true)



}
