% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfmix.R
\name{pfmix}
\alias{pfmix}
\title{Profile Likelihood Method for Normal Mixture with Unequal Variance}
\usage{
pfmix(x, k, m = NULL, numini = NULL)
}
\arguments{
\item{x}{Observations. Can be vector or matrix.}

\item{k}{Ratio of the smallest variance to the largest variance.}

\item{m}{The number of components, equals to 2 by default.}

\item{numini}{The number of initial values used to find the constrained--The default value is 20}
}
\value{
a list of lh:likelihood; mu:estimated means of components;sigma: estimated sd of
components; pi: estimated proportion of components.
}
\description{
pfmix finds the profile likelihood of the m-component normal mixture model using the EM algorithm
when assuming that the ratio of the smallest variance to the largest variance is k.
The function also provide a visualized way to find MLE of k by finding the maximum interior mode for likelihood.
To achieve this, one extra step of plot out likelihood vs k plot for different k is needed.
}
\examples{

#Example 1


n=100;
u=runif(n,0,1);
x1=(u<=0.3)*rnorm(n,0,0.5)+(u>0.3)*rnorm(n,1,1);
k1=0.4378;
est1=pfmix(x1,k1)

# Example 2


x2=(u<=0.3)*rnorm(n,0,0.5)+(u>0.3)*rnorm(n,1.5,1);
k2=0.4879;
est2=pfmix(x2,k2)
}
