% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconc.R
\name{mixLogconcHD}
\alias{mixLogconcHD}
\title{Clustering with Mixtures of Log-concave Distributions using EM Algorithm (Multivariate)}
\usage{
mixLogconcHD(x, C, ini = NULL, nstart = 20, tol = 1e-05, maxiter = 100)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and
p is the dimension of the data.}

\item{C}{number of mixture components.}

\item{ini}{initial value for the EM algorithm. Default value is NULL, which
obtains the initial value using the \code{\link{EMnormal}} function. It can be a list
with the form of \code{list(pi, mu, sigma)}, where \code{pi} is a 1 by C matrix
of mixing proportions, \code{mu} is a C by p matrix of component means, and
\code{sigma} is a p by p by C array of standard deviations or covariance matrices
of \code{C} mixture components.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-05.}

\item{maxiter}{maximum number of iterations for the EM algorithm. Default is 100.}
}
\value{
A list containing the following elements:
\item{loglik}{final log-likelihood.}
\item{pi}{estimated mixing proportions.}
\item{f}{component densities at x.}
\item{sigma}{estimated standard deviation or covariance matrix.}
}
\description{
`mixLogconcHD' is used to estimate the parameters of a mixture of multivariate
log-concave distributions. The correlation structure among components is
calculated by the normal copula.
}
\examples{

x = mvtnorm::rmvnorm(100, c(0, 0), matrix(c(2, 1, 1, 2), nrow = 2))
x = matrix(x, nrow = 100)
x[1:60, ] = x[1:60, ] + 5
\donttest{EMlogc = mixLogconcHD(x, C = 2)}
}
\references{
Chang, G. T., and Walther, G. (2007). Clustering with mixtures of log-concave
distributions. Computational Statistics & Data Analysis, 51(12), 6242-6251.

Hu, H., Wu, Y., and Yao, W. (2016). Maximum likelihood estimation of the mixture
of log-concave densities. Computational Statistics & Data Analysis, 101, 137-147.
}
\seealso{
\code{\link{mixLogconc}}
}
