% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstDepSerialMoebius.R
\name{EstDepSerialMoebius}
\alias{EstDepSerialMoebius}
\title{Dependence measures and statistics for test of randomness for a univariate time series}
\usage{
EstDepSerialMoebius(y, p, trunc.level = 2, graph = FALSE)
}
\arguments{
\item{y}{Time series}

\item{p}{Number of consecutive observations}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}

\item{graph}{Set to TRUE if one wants the dependogram of P-values for the Moebius statistics}
}
\value{
\item{stat}{List of statistics (spearman, vdw, savage) and test combinations Ln and Ln2 (only pairs)}

\item{pvalue}{P-values for the tests}

\item{card}{Cardinaly of the subsets for the Moebius statistics}

\item{subsets}{Subsets for the Moebius statistics}
}
\description{
This function computes copula-based dependence measures for Moebius versions of Spearmans's rho, van der Waerden's coefficient, and Savage's coefficient, as well as their combination for tests of randomness for p consecutive values Y(1), ..., Y(p).
}
\examples{
y<- SimAR1Poisson(c(5,0.2),100)
out <- EstDepSerialMoebius(y,4,4)
}
\references{
B.R Nasri & B.N. Remillard (2022). Copula-based dependence measures for arbitrary data
}
