% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{printConditional}
\alias{printConditional}
\title{Prints Conditional Functions}
\usage{
printConditional(conditionalFunction)
}
\arguments{
\item{conditionalFunction}{the output of the function \code{conditionalMethod}. A list with the interval of the parent
and the final \code{"motbf"} density function fitted in each interval.}
}
\value{
The results  of the conditional function are shown.
}
\description{
Prints the result of an MoTBF conditional function of two variables, i.e. a parent and his child.
}
\examples{
## Data
X <- rexp(500)
Y <- rnorm(500, mean=X)
data <- data.frame(X=X,Y=Y)
cov(data)

## Conditional Learning
parent <- "X"
child <- "Y"
intervals <- 5
potential <- "MOP"
P <- conditionalMethod(data, nameParents=parent, nameChild=child, 
numIntervals=intervals, POTENTIAL_TYPE=potential)
printConditional(P)

}
\seealso{
\link{conditionalMethod}
}
