% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{subsetData}
\alias{subsetData}
\alias{TrainingandTestData}
\alias{newData}
\alias{splitdata}
\title{Subset a Dataset}
\usage{
TrainingandTestData(data, percentage_test, discreteVariables = NULL)

newData(data, nameX, nameY)

splitdata(data, nameVariable, min, max)
}
\arguments{
\item{data}{A dataset of class \code{"data.frame"}.}

\item{percentage_test}{The percentage to be data test. Between 0 and 1.}

\item{discreteVariables}{A \code{"character"} array with the name of the discrete variables.}

\item{nameX}{The name of the child variable in the conditional method.}

\item{nameY}{The name of the parent variables in the conditional method.}

\item{nameVariable}{Name of the variable to filter.}

\item{min}{The lower value of the interval for filter.}

\item{max}{The higher value of the interval for filter.}
}
\value{
A list of datasets for \code{TrainingandTestData()} or a subset of the original
dataset for the others two functions.
}
\description{
Collection of functions for subsetting a dataset by entries, by variables, 
and for splitting it in a training dataset and in a test dataset.
}
\examples{
\donttest{
## Dataset
X <- rnorm(1000)
Y <- rchisq(1000, df = 8)
Z <- rep(letters[1:10], times = 1000/10)
data <- data.frame(X = X, Y = Y, Z = Z)
data <- discreteVariables_as.character(dataset = data, discreteVariables ="Z")

## Training and Test Datasets
TT <- TrainingandTestData(data, percentage_test = 0.2)
TT$Training
TT$Test

## Subset Dataset
newData(data, nameX = "X", nameY = "Z")
splitdata(data, nameVariable = "X", min = 2, max= 3)
}
}
