\name{coeff.sel}
\alias{coeff.sel}

\title{
Helps to select a given number of harmonics from a numerical vector.
}

\description{
\code{coeff.sel} helps to select a given number of harmonics by returning their indices when arranged as a numeric vector. For instance, harmonic coefficients are arranged in the \code{@coeff} slot of \code{Coe}-objects in that way: \deqn{A_1, \dots, A_n, B_1, \dots, B_n, C_1, \dots, C_n, D_1, \dots, D-n} after an elliptical Fourier analysis (see \link{eFourier} and \link{efourier}) while \deqn{C_n and D_n} harmonic are absent for radii variation and tangent angle approaches (see \link{rfourier} and \link{tfourier} respectively). . This function is used internally but might be of interest elwewhere.
}

\usage{
coeff.sel(retain = 8, drop = 0, nb.h = 32, cph = 4)
}

\arguments{
  \item{retain}{\code{numeric}. The number of harmonics to retain.}
  \item{drop}{\code{numeric}. The number of harmonics to drop}
  \item{nb.h}{\code{numeric}. The maximum harmonic rank.}
  \item{cph}{\code{numeric}. Must be set to 2 for \code{rfourier} and \code{tfourier} were used.}
}

\value{
\code{coeff.sel} returns indices that can be used to select columns from an harmonic coefficient matrix.
\code{coeff.split} returns a named list of coordinates.
}
\examples{
coeff.sel(retain=8, drop=0, nb.h=12)        #efourier 
coeff.sel(retain=8, drop=0, nb.h=12, cph=2) #r/tfourier
}
\keyword{Utilities}

