% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-LDA.R
\name{plot_CV}
\alias{plot_CV}
\alias{plot_CV.default}
\alias{plot_CV.LDA}
\title{Plots a cross-validation table as an heatmap}
\usage{
plot_CV(
  x,
  freq = FALSE,
  rm0 = FALSE,
  pc = FALSE,
  fill = TRUE,
  labels = TRUE,
  axis.size = 10,
  axis.x.angle = 45,
  cell.size = 2.5,
  signif = 2,
  ...
)

\method{plot_CV}{default}(
  x,
  freq = FALSE,
  rm0 = FALSE,
  pc = FALSE,
  fill = TRUE,
  labels = TRUE,
  axis.size = 10,
  axis.x.angle = 45,
  cell.size = 2.5,
  signif = 2,
  ...
)

\method{plot_CV}{LDA}(
  x,
  freq = TRUE,
  rm0 = TRUE,
  pc = TRUE,
  fill = TRUE,
  labels = TRUE,
  axis.size = 10,
  axis.x.angle = 45,
  cell.size = 2.5,
  signif = 2,
  ...
)
}
\arguments{
\item{x}{a (cross-validation table) or an LDA object}

\item{freq}{logical whether to display frequencies (within an actual class) or counts}

\item{rm0}{logical whether to remove zeros}

\item{pc}{logical whether to multiply proportion by 100, ie display percentages}

\item{fill}{logical whether to fill cell according to count/freq}

\item{labels}{logical whether to add text labels on cells}

\item{axis.size}{numeric to adjust axis labels}

\item{axis.x.angle}{numeric to rotate x-axis labels}

\item{cell.size}{numeric to adjust text labels on cells}

\item{signif}{numeric to round frequencies using \link{signif}}

\item{...}{useless here}
}
\value{
a ggplot object
}
\description{
Either with frequencies (or percentages) plus marginal sums,
and values as heatmaps. Used in Momocs for plotting cross-validation tables
but may be used for any table (likely with \code{freq=FALSE}).
}
\examples{
h <- hearts \%>\%
     fgProcrustes(0.01) \%>\% coo_slide(ldk=2) \%T>\% stack \%>\%
     efourier(6, norm=FALSE) \%>\% LDA(~aut)

h \%>\% plot_CV()
h \%>\% plot_CV(freq=FALSE, rm0=FALSE, fill=FALSE)
# you can customize the returned gg with some ggplot2 functions
h \%>\% plot_CV(labels=FALSE, fill=TRUE, axis.size=5) + ggplot2::ggtitle("A confusion matrix")

# or build your own using the prepared data_frame:
df <- h \%>\% plot_CV() \%$\% data
df

# you can even use it as a cross-table plotter
bot$fac \%>\% table \%>\% plot_CV()

}
\seealso{
\link{LDA}, \link{plot.LDA}, and (pretty much the same) \link{plot_table}.
}
