% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-layers.R
\name{layers}
\alias{layers}
\alias{layer_frame}
\alias{layer_axes}
\alias{layer_ticks}
\alias{layer_grid}
\alias{layer_box}
\alias{layer_fullframe}
\alias{layer_points}
\alias{layer_ellipses}
\alias{layer_ellipsesfilled}
\alias{layer_ellipsesaxes}
\alias{layer_chull}
\alias{layer_chullfilled}
\alias{layer_stars}
\alias{layer_delaunay}
\alias{layer_density}
\alias{layer_labelpoints}
\alias{layer_labelgroups}
\alias{layer_rug}
\alias{layer_histogram_2}
\alias{layer_density_2}
\alias{layer_title}
\alias{layer_axesnames}
\alias{layer_eigen}
\alias{layer_axesvar}
\alias{layer_legend}
\title{grindr layers for multivariate plots}
\usage{
layer_frame(x, center_origin = TRUE, zoom = 0.9)

layer_axes(x, col = "#999999", lwd = 1/2, ...)

layer_ticks(x, col = "#333333", cex = 3/4, lwd = 3/4, ...)

layer_grid(x, col = "#999999", lty = 3, grid = 3, ...)

layer_box(x, border = "#e5e5e5", ...)

layer_fullframe(x, ...)

layer_points(x, pch = 20, cex = 4/log1p(nrow(x$xy)), transp = 0, ...)

layer_ellipses(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_ellipsesfilled(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_ellipsesaxes(x, conf = 0.5, lwd = 1, alpha = 0, ...)

layer_chull(x, ...)

layer_chullfilled(x, alpha = 0.8, ...)

layer_stars(x, alpha = 0.5, ...)

layer_delaunay(x, ...)

layer_density(
  x,
  levels_density = 20,
  levels_contour = 4,
  alpha = 1/3,
  n = 200,
  density = TRUE,
  contour = TRUE
)

layer_labelpoints(
  x,
  col = par("fg"),
  cex = 2/3,
  font = 1,
  abbreviate = FALSE,
  ...
)

layer_labelgroups(
  x,
  col = par("fg"),
  cex = 3/4,
  font = 2,
  rect = TRUE,
  alpha = 1/4,
  abbreviate = FALSE,
  ...
)

layer_rug(x, size = 1/200, ...)

layer_histogram_2(x, freq = FALSE, breaks, split = FALSE, transp = 0)

layer_density_2(x, bw, split = FALSE, rug = TRUE, transp = 0)

layer_title(x, title = "", cex = 3/4, ...)

layer_axesnames(x, cex = 3/4, name = "Axis", ...)

layer_eigen(x, nb_max = 5, cex = 1/2, ...)

layer_axesvar(x, cex = 3/4, ...)

layer_legend(x, probs = seq(0, 1, 0.25), cex = 3/4, ...)
}
\arguments{
\item{x}{a list, typically returned by \link{plot_PCA}}

\item{center_origin}{\code{logical} whether to center the origin (default \code{TRUE})}

\item{zoom}{\code{numeric} to change the zoom (default \code{0.9})}

\item{col}{color (hexadecimal) to use for drawing components}

\item{lwd}{linewidth for drawing components}

\item{...}{additional options to feed core functions for each layer}

\item{cex}{to use for drawing components}

\item{lty}{linetype for drawing components}

\item{grid}{\code{numeric} number of grid to draw}

\item{border}{color (hexadecimal) to use to draw border}

\item{pch}{to use for drawing components}

\item{transp}{transparency to use (min: 0 defaut:0 max:1)}

\item{conf}{\code{numeric} between 0 and 1 for confidence ellipses}

\item{alpha}{\code{numeric} between 0 and 1 for the transparency of components}

\item{levels_density}{\code{numeric} number of levels to use to feed \code{MASS::kde2d}}

\item{levels_contour}{\code{numeric} number of levels to use to feed \code{graphics::contour}}

\item{n}{\code{numeric} number of grid points to feed \code{MASS::kde2d}}

\item{density}{\code{logical} whether to draw density estimate}

\item{contour}{\code{logical} whether to draw contour lines}

\item{font}{to feed \link{text}}

\item{abbreviate}{\code{logical} whether to abbreviate names}

\item{rect}{\code{logical} whether to draw a rectangle below names}

\item{size}{\code{numeric} as a fraction of graphical window (default: \code{1/200})}

\item{freq}{\code{logical}to feed\verb{[hist] (default:}FALSE`)}

\item{breaks}{to feed \link{hist} (default: calculated on the pooled values)}

\item{split}{\code{logical} whether to split the two distributions into two plots}

\item{bw}{to feed \link{density} (default: \link[stats:bandwidth]{stats::bw.nrd0})}

\item{rug}{\code{logical} whether to add \link{rug} (default: \code{TRUE})}

\item{title}{to add to the plot (default \code{""})}

\item{name}{to use on axes (default \code{"Axis"})}

\item{nb_max}{\code{numeric} number of eigen values to display (default \code{5})}

\item{probs}{\code{numeric} sequence to feed \code{stats::quantile}
and to indicate where to draw ticks and legend labels}
}
\value{
a drawing layer
}
\description{
Useful layers for building custom
mutivariate plots using the cheapbabi approach. See examples.
}
\seealso{
grindr_drawers

Other grindr: 
\code{\link{drawers}},
\code{\link{layers_morphospace}},
\code{\link{mosaic_engine}()},
\code{\link{papers}},
\code{\link{pile}()},
\code{\link{plot_LDA}()},
\code{\link{plot_NMDS}()},
\code{\link{plot_PCA}()}
}
\concept{grindr}
