% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commutationNumbers.R
\name{commutationNumbers}
\alias{commutationNumbers}
\alias{commutationNumbers,mortalityTable-method}
\alias{commutationNumbers,numeric-method}
\alias{commutationNumbers,pensionTable-method}
\title{Calculate the commutation numbers for the given parameters, using the mortality table and an interest rate}
\usage{
commutationNumbers(object, ..., ages = NULL, i = 0.03)

\S4method{commutationNumbers}{mortalityTable}(object, ..., ages = NULL, i = 0.03)

\S4method{commutationNumbers}{numeric}(object, ages, i = 0.03)

\S4method{commutationNumbers}{pensionTable}(object, ..., ages = NULL, i = 0.03)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Other parameters to be passed to the deathProbabilities call (e.g. YOB)}

\item{ages}{Vector of ages for which the probabilities should be extracted and commutation numbers calculates}

\item{i}{Interest rate used for the calculation of the commutation numbers}
}
\description{
Calculate the commutation numbers for the given parameters, using the mortality table and an interest rate
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Calculate the commutation numbers for the given
parameters, using the mortality table and an interest rate

\item \code{numeric}: Calculate the commutation numbers for the given
death probabilities (passed as a numeric vector with argument
name "object"), ages and an interest rate
Return value is a list of data frames

\item \code{pensionTable}: Calculate the commutation numbers for the given
parameters, using the pension table and an interest rate
Return value is a list of data frames
}}

\examples{
mortalityTables.load("Austria_Annuities")
commutationNumbers(AVOe2005R.male, i = 0.03, YOB = 1975)

}
