% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mplustree.R
\name{plot.mplustree}
\alias{plot.mplustree}
\title{Plots tree structure of an Mplus Tree}
\usage{
\method{plot}{mplustree}(x, ...)
}
\arguments{
\item{x}{An object of class "mplustree" (a fitted Mplus Tree)}

\item{...}{Other arguments passed to \code{rpart.plot}}
}
\description{
Wrapper using \code{rpart.plot} package to plot the tree structure of a
fitted Mplus Tree.
}
\details{
Each node of the plot by default contain the -2
         log-likelihood (deviance), the number of individuals
         in the node, and the percentage of the total sample
         in the node.
}
\examples{
\dontrun{
library(lavaan)

script = mplusObject(
   TITLE = "Example #1 - Factor Model;",
   MODEL = "f1 BY x1-x3; f2 BY x4-x6; f3 BY x7-x9;",
   usevariables = c('x1','x2','x3','x4','x5','x6','x7','x8','x9'),
   rdata = HolzingerSwineford1939)

fit = MplusTrees(script, HolzingerSwineford1939, group=~id,
   rPartFormula=~sex+school+grade, control=rpart.control(cp=.01))

fit

plot(fit)
}
}
\author{
Sarfaraz Serang, relying heavily on the \code{rpart.plot}
package by Stephen Milborrow.
}
