% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msde.fit.R
\docType{class}
\name{Mixture.fit.class-class}
\alias{Mixture.fit.class-class}
\title{S4 class for the estimation results when the random effects in the drift follow 
mixture of normal distributions}
\description{
S4 class for the estimation results when the random effects in the drift follow 
mixture of normal distributions
}
\section{Slots}{

\describe{
\item{\code{model}}{character 'OU' or 'CIR'}

\item{\code{drift.random}}{numeric 1, 2, or c(1,2)}

\item{\code{gridf}}{matrix of values on which the estimation of the density of the random effects is done}

\item{\code{mu}}{array estimated value of the mean of the drift random effects at each iteration of the EM algorithm (Niter x nb.mixt x 2)}

\item{\code{omega}}{array estimated value of the standard deviation of the drift random effects at each iteration of the EM algorithm (Niter x nb.mixt x 2)}

\item{\code{mixt.prop}}{matrix estimated value of the mixing proportions at each iteration of the EM algorithm (Niter x nb.mixt)}

\item{\code{sigma2}}{numeric estimated value of \eqn{\sigma^2}}

\item{\code{index}}{index of the valid trajectories for the considered model (numeric)}

\item{\code{indexestim}}{index of the trajectories used for the estimation (numeric)}

\item{\code{estimphi}}{matrix of the estimator of the drift random effects}

\item{\code{probindi}}{matrix of posterior component probabilities}

\item{\code{estimf}}{matrix estimator of the density of the drift random effects}

\item{\code{estim.drift.fix}}{numeric 1 if the user asked for the estimation of fixed parameter in the drift}

\item{\code{bic}}{numeric bic}

\item{\code{aic}}{numeric aic}

\item{\code{times}}{vector of observation times, storage of input variable}

\item{\code{X}}{matrix of observations, storage of input variable}
}}

