% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEdensity.R
\name{Get_llk}
\alias{Get_llk}
\title{Compute the log-likelihood function}
\usage{
Get_llk(P, Y, Z, N, mat, We, Wpca, K0Z, K1Z, SSZ, LoadBs, LoadAs, ModelType)
}
\arguments{
\item{P}{time-series of spanned factors (N x T or CN x T)}

\item{Y}{time-series of yields (J x T or CJ x T)}

\item{Z}{time-series of risk factors (F x T)}

\item{N}{number of country-specific spanned factors}

\item{mat}{vector of maturities (in years) of yields used in estimation (J x 1)}

\item{We}{matrix of weights of the portfolios observed with errors ((J-N) x J or C(J-N) x CJ)}

\item{Wpca}{matrix of weights of the portfolios observed without errors (N x J or CN x CJ)}

\item{K0Z}{matrix of intercepts (P-dynamics)}

\item{K1Z}{feedback matrix (P-dynamics)}

\item{SSZ}{variance-covariance matrix (P-dynamics)}

\item{LoadBs}{list containing the B loadings}

\item{LoadAs}{list containing the A loadings}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\description{
Compute the log-likelihood function
}
\keyword{internal}
