% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{NumOutputs}
\alias{NumOutputs}
\title{Constructs the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, GFEVDs, and term premia)}
\usage{
NumOutputs(
  ModelType,
  ModelPara,
  InputsForOutputs,
  FactorLabels,
  Economies,
  Folder2save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{ModelPara}{list. Point estimates of the model parameters. See outputs from \code{\link{Optimization}}}

\item{InputsForOutputs}{list. Inputs for generating IRFs, GIRFs, FEVDs, GFEVDs, and Term Premia.}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{Folder2save}{Folder path where the outputs will be stored. Default option saves the outputs in a temporary directory.}

\item{verbose}{Logical flag controlling function messaging. Default is TRUE.}
}
\value{
An object of class 'ATSMNumOutputs' containing the following keys elements:
\enumerate{
\item Model parameter estimates
\item Model fit of bond yields
\item IRFs
\item FEVDs
\item GIRFs
\item GFEVDs
\item Bond yield decomposition
}
}
\description{
Constructs the model numerical outputs (model fit, IRFs, GIRFs, FEVDs, GFEVDs, and term premia)
}
\details{
Both IRFs and FEVDs are computed using the Cholesky decomposition method. The risk factors are ordered as follows: (i) global unspanned factors, and (ii) domestic unspanned and spanned factors for each country. The order of countries follows the sequence defined in the \code{Economies} vector.
}
\section{Available methods}{

- `autoplot(object, type)`
}

\examples{
data("ParaSetEx")
data("InpForOutEx")
# Adjust inputs according to the loaded features
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar = "Eco_Act", GlobalVar = "Gl_Eco_Act", Economy, ModelType)

NumOut <- NumOutputs(ModelType, ParaSetEx, InpForOutEx, FacLab, Economy,
  Folder2save = NULL, verbose = FALSE
)

}
\references{
Pesaran, H. Hashem, and Shin, Yongcheol. "Generalized impulse response analysis in linear multivariate models." Economics letters 58.1 (1998): 17-29.
}
