% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_Uni_MomCum_Th}
\alias{distr_Uni_MomCum_Th}
\title{Moments and cumulants Uniform Distribution on the Sphere}
\usage{
distr_Uni_MomCum_Th(r, d, nCum = FALSE)
}
\arguments{
\item{r}{highest order of moments and cumulants}

\item{d}{dimension}

\item{nCum}{if it is TRUE then cumulants are calculated}
}
\value{
The list of moments and cumulants in vector form
}
\description{
By default, only moments are provided
}
\examples{
# The first four moments for d=3
distr_Uni_MomCum_Th(4,3,nCum=0)
# The first four moments and cumulants for d=3
distr_Uni_MomCum_Th(4,3,nCum=4)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 Proposition 5.3 p.297
}
\seealso{
Other Theoretical Moments and Cumulants: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Theoretical Moments and Cumulants}
