% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_ZabsM_MomCum_Th}
\alias{distr_ZabsM_MomCum_Th}
\title{Moments and cumulants multivariate central folded Normal distribution}
\usage{
distr_ZabsM_MomCum_Th(r, d, nMu = FALSE)
}
\arguments{
\item{r}{The highest cumulant (moment) order}

\item{d}{dimension}

\item{nMu}{if True then moments are calculated as well.}
}
\value{
The list of cumulants (and moments) in vector form.
}
\description{
Provides the theoretical moments and cumulants of the multivariate central Folded
Normal distribution. By default only cumulants are provided.
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Lemma 5.2 p. 249
}
\seealso{
Other Theoretical Moments and Cumulants: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Theoretical Moments and Cumulants}
