% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LHS.R
\name{LHS_plot}
\alias{LHS_plot}
\title{Generate a 3D scatterplot of plant traits}
\usage{
LHS_plot(
  data,
  colors = c("#30123BFF", "#4777EFFF", "#1BD0D5FF", "#62FC6BFF", "#D2E935FF",
    "#FE9B2DFF", "#DB3A07FF", "#7A0403FF"),
  log_transform = TRUE
)
}
\arguments{
\item{data}{A data frame containing columns: SLA, Height, SeedMass, and LHS_strategy.}

\item{colors}{A vector of colors for different LHS strategies. Default is a predefined color palette.}

\item{log_transform}{Logical, indicating whether to log-transform the data. Default is TRUE.}
}
\value{
A 3D scatterplot of SLA, Height, and Seed Mass (optionally log-transformed), with points colored by LHS strategy.
}
\description{
This function creates a three-dimensional scatterplot of plant traits (Specific Leaf Area, Height, and Seed Mass) based on the Leaf-Height-Seed (LHS) plant ecology strategy scheme.
}
\details{
The function performs the following steps:
Checks if the input data contains the required columns.
Converts LHS_strategy to a factor.
Optionally log-transforms the data based on the log_transform parameter.
Creates a 3D scatterplot using (potentially log-transformed) values of SLA, Height, and Seed Mass.
Colors points based on LHS strategy.
Adds a legend to identify different LHS strategies.
}
\examples{
data(PFF)
pff <- PFF[, c("SLA", "Height", "SeedMass")]
result <- LHS(pff)
LHS_plot(result)
LHS_plot(result, log_transform = FALSE)

}
\references{
\enumerate{
\item Westoby, M. (1998). A leaf-height-seed (LHS) plant ecology strategy scheme. Plant and Soil, 199, 213–227. https://doi.org/10.1023/A:1004327224729
\item Yang, J., Wang, Z., Zheng, Y., & Pan, Y. (2022). Shifts in plant ecological strategies in remnant forest patches along urbanization gradients. Forest Ecology and Management, 524, 120540. https://doi.org/10.1016/j.foreco.2022.120540
}
}
