% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnovaCluster.R
\name{AnovaCluster}
\alias{AnovaCluster}
\title{Analise de variancia considerando clusters}
\usage{
AnovaCluster(Cluster,Dados=Dados,design=design,test="Pillai")
}
\arguments{
\item{Cluster}{Vetor contendo os grupos que cada individuo/tratamento pertence. Veja os exemplos.}

\item{Dados}{Matriz contendo os dados para execucao da analise. Para cada
modelo o conjunto de dados precisa estar organizado de uma forma apropriada:
\itemize{ \item Design 1: Deve ter apenas os dados numericos da pesquisa.
 Na primeira linha não deve ter o nome dos individuos/tratamentos.
  \item Design 2 e 3: As duas primeiras colunas devem conter a
identificacao dos tratamentos e repeticoes/blocos, e as demais os valores
observanos nas variaveis respostas. \item Modelo 4: As tres primeiras
colunas devem conter as informacoes dos tratamentos, linhas e colunas, e
posteriormente, os valores da variavel resposta. \item Modelos 5 e 6: as
primeiras colunas precisam ter a informacao do fator A, fator B,
repeticao/bloco, e posteriormente, as variaveis respostas.}}

\item{design}{Valor numerico indicando o delineamento:
\itemize{
\item 1 =  Experimento sem repeticoes.
\item 2 =  Delineamento inteiramente casualizado (DIC) .
 \item 3 = Delineamento em blocos casualizados (DBC).
 \item 4 = Delineamento em quadrado latino (DQL).
  \item 5 =Esquema fatorial duplo em DIC.
  \item 6 = Esquema fatorial duplo em DBC.}}

\item{test}{Nome do teste que se deseja utilizar na manova ("Pillai", "Wilks", "Hotelling-Lawley" ou "Roy").}
}
\value{
A funcao retorna a ANOVA, para todas as variaveis considerando os clustes criados.
}
\description{
Esta funcao retorna o resultado da analise de variancia
 considerando clusters formados por diferentes metodos como dendrograma, kmeans,
 Tocher, etc.
}
\examples{
\donttest{
#######################################################
#######################################################
#Dados sem repeticoes considerando o Kmeans
data(Dados.MED)
Km=Kmeans(Dados = Dados.MED,design = 1,nclusters = 4)
AnovaCluster(Cluster = Km$Classe,Dados=Dados.MED,design = 1)

#Dados sem repeticoes considerando o Tocher
dist=Distancia(Dados = Dados.MED,Metodo = 3)
TO=Tocher(Dist = dist)
TO
AnovaCluster(Cluster = TO$Classe,Dados=Dados.MED,design = 1)

#Dados sem repeticoes considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Frey")
Dendro
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.MED,design = 1)
#######################################################################
#######################################################################
#DIC considerando o Kmeans
data(Dados.DIC)
N=Kmeans_NumeroOtimo2(Dados = Dados.DIC,design = 2)
Km=Kmeans(Dados = Dados.DIC,design = 3,nclusters = N$ClusterNumber)
Km$predict
AnovaCluster(Cluster = Km$Classe,Dados=Dados.DIC,design = 2)

#DIC considerando o Tocher
m=MANOVA(Dados.DIC,Modelo=1)
dist=Distancia(Dados = m$Med,Metodo = 3)
TO=Tocher(Dist = dist)
TO
AnovaCluster(Cluster = TO$Classe,Dados=Dados.DIC,design = 2)

#DIC considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Frey")
Dendro
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.DIC,design = 2)

#######################################################################
#######################################################################
#DBC considerando o Kmeans
data(Dados.DBC)
n=Kmeans_NumeroOtimo2(Dados = Dados.DBC,design = 3)
Km=Kmeans(Dados = Dados.DBC,design = 3,nclusters = n$ClusterNumber)
Km$predict
AnovaCluster(Cluster = Km$Classe,Dados=Dados.DBC,design = 3)

#DBC considerando o Tocher
m=MANOVA(Dados.DBC,Modelo=2)
dist=Distancia(Dados = m$Med,Metodo = 3)
TO=Tocher(Dist = dist)
dist
TO
AnovaCluster(Cluster = TO$Classe,Dados=Dados.DBC,design = 3)

#DBC considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Mcclain")
Dendro$Classe
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.DBC,design = 3)


#######################################################################
#######################################################################
#DQL considerando o Kmeans
data(Dados.DQL)
n=Kmeans_NumeroOtimo2(Dados = Dados.DQL,design = 4)
Km=Kmeans(Dados = Dados.DQL,design = 4,nclusters = n$ClusterNumber)
Km$predict
AnovaCluster(Cluster = Km$Classe,Dados=Dados.DQL,design = 4)

#DQL considerando o Tocher
m=MANOVA(Dados.DQL,Modelo=2)
dist=Distancia(Dados = m$Med,Metodo = 3)
dist
TO=Tocher(Dist = dist)
TO
AnovaCluster(Cluster = TO$Classe,Dados=Dados.DQL,design = 4)

#DQL considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Dunn")
Dendro$Classe
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.DQL,design = 4)



#######################################################################
#######################################################################
#Fat duplo em dic considerando o Kmeans
data("Dados.Fat2.DIC")
n=Kmeans_NumeroOtimo2(Dados = Dados.Fat2.DIC,design = 5)
Km=Kmeans(Dados = Dados.Fat2.DIC,design = 5,nclusters = n$ClusterNumber)
Km$predict
AnovaCluster(Cluster = Km$Classe,Dados=Dados.Fat2.DIC,design = 5)

#Fat2.DIC considerando o Tocher
m=MANOVA(Dados.Fat2.DIC,Modelo=4)
dist=Distancia(Dados = m$Med,Metodo = 3)
TO=Tocher(Dist = dist)
TO$Classe
AnovaCluster(Cluster = TO$Classe,Dados=Dados.Fat2.DIC,design = 5)

#Fat2.DIC considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Dunn")
Dendro$Classe
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.Fat2.DIC,design = 5)



#######################################################################
#######################################################################
#Fat duplo em dbc considerando o Kmeans
data("Dados.Fat2.DBC")
n=Kmeans_NumeroOtimo2(Dados = Dados.Fat2.DBC,design = 6)
Km=Kmeans(Dados = Dados.Fat2.DBC,design = 5,nclusters = n$ClusterNumber)
Km$predict
AnovaCluster(Cluster = Km$Classe,Dados=Dados.Fat2.DBC,design = 5)

#Fat2.DBC considerando o Tocher
m=MANOVA(Dados.Fat2.DBC,Modelo=5)
dist=Distancia(Dados = m$Med,Metodo = 3)
TO=Tocher(Dist = dist)
TO$Classe
AnovaCluster(Cluster = TO$Classe,Dados=Dados.Fat2.DBC,design = 5)

#Fat2.DBC considerando o Dendrograma
Dendro=Dendrograma(Dissimilaridade = dist,corte="Cindex")
Dendro$Classe
AnovaCluster(Cluster = Dendro$Classe,Dados=Dados.Fat2.DBC,design = 6)

}
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR


CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p. (ISBN 13:978 8581270630)

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)
}
\seealso{
\code{\link{Kmeans}}, \code{\link{Tocher}} , \code{\link{Dendrograma}}
}
