/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Map;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.stats.DoubleWeightedMean;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.eval.AbstractEvaluator;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.EvaluationResultImpl;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EstimatedStrengthEvaluator
extends AbstractEvaluator {
    private static final Logger log = LoggerFactory.getLogger(EstimatedStrengthEvaluator.class);

    @Override
    protected boolean isSplitTestByPrefValue() {
        return false;
    }

    @Override
    public EvaluationResult evaluate(MyrrixRecommender recommender, RescorerProvider provider, Multimap<Long, RecommendedItem> testData) throws TasteException {
        DoubleWeightedMean score = new DoubleWeightedMean();
        int count = 0;
        for (Map.Entry<Long, RecommendedItem> entry : testData.entries()) {
            long userID = entry.getKey();
            RecommendedItem itemPref = entry.getValue();
            try {
                float estimate = recommender.estimatePreference(userID, itemPref.getItemID());
                Preconditions.checkState(LangUtils.isFinite(estimate));
                score.increment(1.0 - (double)estimate, itemPref.getValue());
            }
            catch (NoSuchItemException nsie) {
            }
            catch (NoSuchUserException nsue) {
                // empty catch block
            }
            if (++count % 100000 != 0) continue;
            log.info("Score: {}", (Object)score);
        }
        log.info("Score: {}", (Object)score);
        return new EvaluationResultImpl(score.getResult());
    }

    public static void main(String[] args) throws Exception {
        EstimatedStrengthEvaluator eval = new EstimatedStrengthEvaluator();
        EvaluationResult result = eval.evaluate(new File(args[0]));
        log.info(result.toString());
    }
}

