/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.Preconditions;
import org.apache.commons.math3.util.FastMath;

public final class ParameterRange {
    private final double min;
    private final double max;
    private final boolean integerOnly;

    public ParameterRange(int min, int max) {
        this(min, max, true);
    }

    public ParameterRange(double min, double max) {
        this(min, max, false);
    }

    private ParameterRange(double min, double max, boolean integerOnly) {
        Preconditions.checkArgument(max >= min, "Max must not be less than min");
        this.min = min;
        this.max = max;
        this.integerOnly = integerOnly;
    }

    public Number[] buildSteps(int numSteps) {
        Preconditions.checkArgument(numSteps >= 2, "numSteps must be at least 2: {}", numSteps);
        if (this.min == this.max) {
            return new Number[]{this.maybeRound(this.min)};
        }
        if (this.integerOnly) {
            int roundedMin = (int)FastMath.round(this.min);
            int roundedMax = (int)FastMath.round(this.max);
            int maxResonableSteps = roundedMax - roundedMin + 1;
            if (numSteps >= maxResonableSteps) {
                Number[] sequence = new Number[maxResonableSteps];
                for (int i = 0; i < sequence.length; ++i) {
                    sequence[i] = roundedMin + i;
                }
                return sequence;
            }
        }
        Number[] stepValues = new Number[numSteps];
        stepValues[0] = this.maybeRound(this.min);
        stepValues[stepValues.length - 1] = this.maybeRound(this.max);
        double range = this.max - this.min;
        for (int i = 1; i < stepValues.length - 1; ++i) {
            double fraction = (double)i / (double)(numSteps - 1);
            stepValues[i] = this.maybeRound(this.min + range * fraction * fraction);
        }
        return stepValues;
    }

    private Number maybeRound(double value) {
        if (this.integerOnly) {
            return FastMath.round(value);
        }
        return value;
    }

    public String toString() {
        return this.maybeRound(this.min) + ":" + this.maybeRound(this.max);
    }
}

