/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import net.myrrix.common.parallel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Paralleler<T> {
    private static final Logger log = LoggerFactory.getLogger(Paralleler.class);
    private final String name;
    private final Iterator<T> values;
    private final Processor<T> processor;

    public Paralleler(Iterator<T> values, Processor<T> processor) {
        this(values, processor, null);
    }

    public Paralleler(Iterator<T> values, Processor<T> processor, String name) {
        Preconditions.checkNotNull(values);
        Preconditions.checkNotNull(processor);
        this.values = values;
        this.processor = processor;
        this.name = name;
    }

    public void runInSerial() throws ExecutionException {
        AtomicLong count = new AtomicLong(0L);
        while (this.values.hasNext()) {
            this.processor.process(this.values.next(), count.incrementAndGet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInParallel() throws InterruptedException, ExecutionException {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        if (this.name != null) {
            builder.setNameFormat(this.name + "-%s");
        }
        int numCores = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(numCores, builder.build());
        try {
            this.runInParallel(executor, numCores);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInParallel(ExecutorService executor, int parallelism) throws InterruptedException, ExecutionException {
        ArrayList<ParallelWorker> callables = Lists.newArrayListWithCapacity(parallelism);
        AtomicLong count = new AtomicLong(0L);
        for (int i = 0; i < parallelism; ++i) {
            callables.add(new ParallelWorker(count));
        }
        ArrayList futures = Lists.newArrayListWithCapacity(parallelism);
        boolean done = false;
        try {
            for (Callable callable : callables) {
                futures.add(executor.submit(callable));
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    log.warn("Exception from worker {}", (Object)this.name, (Object)e.getCause());
                    throw e;
                }
            }
            done = true;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    private final class ParallelWorker
    implements Callable<Object> {
        private final AtomicLong count;

        private ParallelWorker(AtomicLong count) {
            this.count = count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws ExecutionException {
            while (true) {
                Object value;
                Iterator iterator = Paralleler.this.values;
                synchronized (iterator) {
                    if (!Paralleler.this.values.hasNext()) {
                        return null;
                    }
                    value = Paralleler.this.values.next();
                }
                Paralleler.this.processor.process(value, this.count.incrementAndGet());
            }
        }
    }
}

