/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;

public final class MostPopularItemsServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        try {
            IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getMostPopularItemsRescorer(recommender, MostPopularItemsServlet.getRescorerParams(request));
            this.output(request, response, recommender.mostPopularItems(MostPopularItemsServlet.getHowMany(request), rescorer));
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
    }
}

