/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client.translating;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import java.io.Serializable;
import net.myrrix.client.translating.TranslatedRecommendedItem;
import net.myrrix.common.LangUtils;

public final class GenericTranslatedRecommendedItem
implements TranslatedRecommendedItem,
Serializable {
    private final String itemID;
    private final float value;

    public GenericTranslatedRecommendedItem(String itemID, float value) {
        Preconditions.checkNotNull(itemID);
        Preconditions.checkArgument(LangUtils.isFinite(value));
        this.itemID = itemID;
        this.value = value;
    }

    @Override
    public String getItemID() {
        return this.itemID;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    public String toString() {
        return "GenericTranslatedRecommendedItem[item:" + this.itemID + ", value:" + this.value + ']';
    }

    public int hashCode() {
        return this.itemID.hashCode() ^ Floats.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenericTranslatedRecommendedItem)) {
            return false;
        }
        TranslatedRecommendedItem other = (TranslatedRecommendedItem)o;
        return this.itemID.equals(other.getItemID()) && this.value == other.getValue();
    }
}

