% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_rcc.R
\name{qc_rcc}
\alias{qc_rcc}
\title{qc_rcc}
\usage{
qc_rcc(data_directory, nacho_df, id_colname, housekeeping_genes,
  housekeeping_predict, housekeeping_norm, normalisation_method, n_comp)
}
\arguments{
\item{data_directory}{[character] A character string of the directory where the data are stored.}

\item{nacho_df}{[data.frame] A \code{data.frame} with all columns from the sample sheet \code{ssheet_csv}
and all computed columns, i.e., quality-control metrics and counts, with one sample per row.}

\item{id_colname}{[character] Character string of the column in \code{ssheet_csv} that matches
the file names in \code{data_directory}.}

\item{housekeeping_genes}{[vector(character)] A vector of names of the miRNAs/mRNAs
that should be used as housekeeping genes. Default is \code{NULL}.}

\item{housekeeping_predict}{[logical] Boolean to indicate whether the housekeeping genes
should be predicted (\code{TRUE}) or not (\code{FALSE}). Default is \code{FALSE}.}

\item{housekeeping_norm}{[logical] Boolean to indicate whether the housekeeping normalisation should be performed.
Default is \code{TRUE}.}

\item{normalisation_method}{[character] Either \code{"GEO"} or \code{"GLM"}.
Character string to indicate normalisation using the geometric mean (\code{"GEO"})
or a generalized linear model (\code{"GLM"}). Default is \code{"GEO"}.}

\item{n_comp}{[numeric] Number indicating the number of principal components to compute.
Cannot be more than n-1 samples. Default is \code{10}.}
}
\value{
[list]
}
\description{
qc_rcc
}
\keyword{internal}
