\name{MergeSNPsGenes}
\Rdversion{1.1}
\alias{MergeSNPsGenes}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Function to merge SNP information and Gene information
}
\description{
Function to merge SNP information and Gene information as generated by
the NCBI2R package
}
\usage{
MergeSNPsGenes(snpdf, genedf, quiet = FALSE, markercolumn = "marker")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{snpdf}{
The dataframe from GetSNPInfo.
}
  \item{genedf}{
The dataframe from GetGeneInfo.
}
  \item{quiet}{
Reduces the amount of input on screen.
}
  \item{markercolumn}{
The name of the column in the dataframe that contains the SNP markers.
}
}
\details{
This is a special version of the R merge function. It was created
because a SNP can be found in more than one overlapping gene. It must be
used to merge a dataframe of SNPs (from GetSNPInfo) with a dataframe of
gene information (from GetGeneInfo).
}
\value{
A dataframe.
}

\author{
Scott Melville.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~


\examples{

 \donttest{
snplist<-c("rs12345","rs333","rs624662")
mySNPs<-GetSNPInfo(snplist)
mySNPs<-SplitGenes(mySNPs)
mygenes<-GetGeneInfo(mySNPs$locusID)
dataset<-MergeSNPsGenes(mySNPs,mygenes)
}
}