% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NFPRefnet-class.R
\name{NFPRefnet-class}
\alias{NFPRefnet-class}
\title{\code{NFPRefnet-class}}
\description{
An S4 object for storing NFP reference network information.
}
\section{Slots}{

\describe{
\item{\code{Refnet,}}{object of graphNEL list represents the basic networks, and each
elements contains a group of basic networks.}

\item{\code{group,}}{a character vector whose length is the same with \emph{Refnet},
the group names of basic networks.}

\item{\code{name,}}{names of the basic networks, with the same data structure
with \emph{Refnet}.}

\item{\code{organism,}}{character, indicating the activation organism of basic networks.
#'@section method:
   \itemize{
     \item{net, \code{signature(object = "NFPRefnet")}:
       extract the basic networks}
     \item{group, \code{signature(object = "NFPRefnet")}:
       extract group information}
     \item{subnet, \code{signature(object = "NFPRefnet")}:
       subset basic networks, e.g. a group of a networks or same networks of
       a given group}
     \item{refnet_name, \code{signature(object = "NFPRefnet")}:
       the  names of basic networks}
     \item{show, \code{signature(object = "NFPRefnet")}:
       display methods for S4 classes NFPRefnet, see also
       \code{\link[methods]{show}}}
   }}
}}

\seealso{
\code{\link{show-methods}},
\code{\link{net-methods}}, \code{\link{refnet_name-methods}},
\code{\link{group-methods}}, \code{\link{subnet-methods}}
}
