% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_stats.R
\name{wl_stats}
\alias{wl_stats}
\title{Calculate some stats about the waiting list}
\usage{
wl_stats(waiting_list, target_wait = 4, start_date = NULL, end_date = NULL)
}
\arguments{
\item{waiting_list}{data.frame. A df of referral dates and removals}

\item{target_wait}{numeric. The required waiting time}

\item{start_date}{date. The start date to calculate from}

\item{end_date}{date. The end date to calculate to}
}
\value{
data.frame. A df of important waiting list statistics
}
\description{
A summary of all the key stats associated with a waiting list
}
\examples{

referrals <- c.Date("2024-01-01", "2024-01-04", "2024-01-10", "2024-01-16")
removals <- c.Date("2024-01-08", NA, NA, NA)
waiting_list <- data.frame("referral" = referrals, "removal" = removals)
waiting_list_stats <- wl_stats(waiting_list)

}
