% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_randomrectangularcluster.R
\name{nlm_randomrectangularcluster}
\alias{nlm_randomrectangularcluster}
\title{nlm_randomrectangularcluster}
\usage{
nlm_randomrectangularcluster(ncol, nrow, resolution = 1, minl, maxl,
  rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr Resolution of the raster.}

\item{minl}{[\code{numerical(1)}]\cr The minimum possible width and height for each random rectangular cluster.}

\item{maxl}{[\code{numerical(1)}]\cr The maximum possible width and height for each random rectangular cluster.}

\item{rescale}{[\code{logical(1)}]\cr If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulates a random rectangular clusters neutral landscape model with values ranging 0-1.
}
\details{
The random rectangular cluster algorithm starts to fill a raster randomly
with rectangles defined by \code{minl} and \code{maxl} until the surface
of the landscape is completely covered.
This is one type of realisation of a "falling/dead leaves" algorithm,
for more details see Galerne & Goussea (2012).
}
\examples{
# simulate random rectangular cluster
randomrectangular_cluster <- nlm_randomrectangularcluster(ncol = 50,
                                                          nrow = 30,
                                                          minl = 5,
                                                          maxl = 10)
\dontrun{
# visualize the NLM
landscapetools::util_plot(randomrectangular_cluster)
}

}
\references{
Gustafson, E.J. & Parker, G.R. (1992). Relationships between landcover
proportion and indices of landscape spatial pattern. \emph{Landscape ecology},
7, 101–110.
Galerne B. & Gousseau Y. (2012). The Transparent Dead Leaves Model. Advances in
Applied Probability, \emph{Applied Probability Trust}, 44, 1–20.
}
