% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqlog.R
\name{seqlog}
\alias{seqlog}
\title{Log-scale equidistant sequences}
\usage{
seqlog(from, to, length.out)
}
\arguments{
\item{from}{start of sequence}

\item{to}{end of sequence}

\item{length.out}{length of sequence}
}
\value{
A numeric vector.
}
\description{
Useful for generating sequences to be plotted on log scale. This
is really simple - seq is run on from and to after log
transformation, then the exponential is reported.
}
\examples{
library(ggplot2)
df <- data.frame(x=seqlog(1,100,100))
df <- transform(df, y=x/(10+x))
## the points are equidistant on the log x scale
ggplot(df,aes(x,y))+geom_point()+scale_x_log10()
}
