% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMorderColumns.R
\name{NMorderColumns}
\alias{NMorderColumns}
\title{Standardize column order in Nonmem input data}
\usage{
NMorderColumns(
  data,
  first,
  last,
  lower.last = FALSE,
  chars.last = TRUE,
  alpha = TRUE,
  col.nomtime,
  col.time = "TIME",
  col.row,
  col.flagn,
  col.dv = "DV",
  as.fun = NULL,
  quiet
)
}
\arguments{
\item{data}{The dataset which columns to reorder.}

\item{first}{Columns that should come almost first. See details.}

\item{last}{Columns to move to back of dataset. If you work with a
large dataset, and some columns are irrelevant for the Nonmem
runs, you can use this argument.}

\item{lower.last}{Should columns which names contain lowercase
characters be moved towards the back? Some people use a
standard of lowercase variables (say "race") being character
representations ("Asian", "Caucasian", etc.) variables and the
uppercase (1,2,...) being the numeric representation for
Nonmem.}

\item{chars.last}{Should columns which cannot be converted to
numeric be put towards the end? A column can be a character or
a factor in R, but still be valid in Nonmem (often the case
for ID which can only contain numeric digits but really is a
character or factor). So rather than only looking at the
column class, the columns are attempted converted to
numeric. Notice, it will attempted to be converted to numeric
to test whether Nonmem will be able to make sense of it, but
the values in the resulting dataset will be untouched. No
values will be edited. If TRUE, logicals will always be put
last. NA's must be NA or ".".}

\item{alpha}{Sort columns alphabetically. Notice, this is the last
order priority applied.}

\item{col.nomtime}{The name of the column containing nominal
time. If given, it will put the column quite far left, just
after row counter and ID. Default value is NOMTIME and can be
configured with NMdataConf.}

\item{col.time}{The name of the column containing actual time. If
given, it will put the column quite far left, just after row
counter, subject ID, and nominal time. Default value is TIME.}

\item{col.row}{A row counter column. This will be the first column
in the dataset. Technically, you can use it for whatever
column you want first. Default value is ROW and can be
configured with NMdataConf.}

\item{col.flagn}{The name of the column containing numerical flag
values for data row omission. Default value is FLAG and can be
configured with NMdataConf.}

\item{col.dv}{a vector of column names to put early to represent
dependent variable(s). Default is DV.}

\item{as.fun}{The default is to return a data.table if data is a
data.table and return a data.frame in all other cases. Pass a
function in as.fun to convert to something else. The default
can be configured using NMdataConf. However, if data is a
data.table, settings via NMdataConf are ignored.}

\item{quiet}{If true, no warning will be given about missing
standard Nonmem columns.}
}
\value{
data with modified column order.
}
\description{
Order data columns for easy export to Nonmem. No data values are
edited. The order is configurable through multiple arguments. See
details.
}
\details{
This function will change the order of columns but it
    will never edit values in any columns. The ordering is by the
    following steps, each step depending on corresponding
    argument.

\itemize{
 \item{"col.row - "}{Row id if argument row is non-NULL}
 \item{"not editable - "}{ID (if a column is called ID)}
 \item{"col.nomtime - "}{Nominal time.}
 \item{"col.time - "}{Actual time.}
 \item{"first - "}{user-specified first columns}
 \item{"Only col.dv editable - "}{Standard Nonmem columns: EVID, CMT, AMT, RATE, col.dv, MDV}
 \item{"last - "}{user-specified last columns}
 \item{"chars.last - "}{numeric, or interpretable as numeric}
 \item{"not editable - "}{less often used Nonmem names: col.flagn, OCC, ROUTE, GRP, TRIAL, DRUG, STUDY}
 \item{"lower.last - "}{lower case in name}
 \item{"alpha - "}{Alphabetic/numeric sorting}
}
}
\seealso{
Other DataCreate: 
\code{\link{NMstamp}()},
\code{\link{NMwriteData}()},
\code{\link{addTAPD}()},
\code{\link{findCovs}()},
\code{\link{findVars}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
