% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findVars.R
\name{findVars}
\alias{findVars}
\title{Extract columns that vary within values of other columns in a data.frame}
\usage{
findVars(data, by = NULL, cols.id, as.fun = NULL)
}
\arguments{
\item{data}{data.frame in which to look for covariates}

\item{by}{optional covariates will be searched for in combinations of
values in these columns. Often by will be either empty or ID. But
it can also be both say c("ID","DRUG") or c("ID","TRT").}

\item{cols.id}{Deprecated. Use by instead.}

\item{as.fun}{The default is to return a data.table if data is a data.table
and return a data.frame in all other cases. Pass a function in as.fun to
convert to something else. If data is not a data.table, the default can
be configured using NMdataConf.}
}
\value{
a data set with as many rows as in data.
}
\description{
If you want to look at the variability of a number of columns and you want
to disregard those that are constant. Like for findCovs, by can be of
arbitrary length.
}
\details{
Use this to exclude columns that are constant within by. If
    by=ID, this could be to get only time-varying covariates.
}
\examples{
dt1 <- data.frame(ID=c(1,1,2,2),
                  OCC=c(1,2,1,2),
               ## ID level
                  eta1=c(1,1,3,3),
               ## occasion level
                  eta2=c(1,3,1,5),
               ## not used
                  eta3=0
               )
## model level
findCovs(dt1)
## ID level
findCovs(dt1,"ID")
## acual ID level
findVars(findCovs(dt1,"ID"))
## occasion level
findCovs(findVars(dt1,"ID"),c("ID","OCC"))
}
\seealso{
Other DataCreate: 
\code{\link{NMorderColumns}()},
\code{\link{NMstamp}()},
\code{\link{NMwriteData}()},
\code{\link{addTAPD}()},
\code{\link{findCovs}()},
\code{\link{flagsAssign}()},
\code{\link{flagsCount}()},
\code{\link{mergeCheck}()},
\code{\link{tmpcol}()}
}
\concept{DataCreate}
