% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-run-summaries.R
\name{nm_summary}
\alias{nm_summary}
\alias{summary_wide}
\alias{summary_long}
\title{Generate a summary of NONMEM results}
\usage{
summary_wide(
  ...,
  include_fields = character(),
  parameters = c("none", "new", "all"),
  m = TRUE,
  trans = TRUE
)

summary_long(..., parameters = c("none", "new", "all"))
}
\arguments{
\item{...}{Arguments passed to \code{\link[=summary]{summary()}}, usually a vector of nm object +
options.}

\item{include_fields}{Character vector of nm object fields to include as
columns in the output. Default is empty.}

\item{parameters}{Character. Either \code{"none"} (default), \code{"new"}, or \code{"all"}
indicating whether parameter values should be included in the summary
\code{tibble}.  Specifying \code{"new"} means that only parameters that aren't in the
\code{parent} run are included in outputs.  This is useful if wanting to know
the value of an added parameter but not all the parameters (e.g. in a
covariate analysis).}

\item{m}{Logical (default = \code{TRUE}). Should model object be included as the
\code{m} column.}

\item{trans}{Logical (default = \code{TRUE}). Should parameters be transformed in
accordance with $THETA/$OMEGA/$SIGMA comments.  This is only valid if
\code{parameters} is \code{"new"} or \verb{"all}.}
}
\value{
A wide format \code{tibble} with run results.

A long format \code{tibble} with run results coerced to \code{character} form.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get wide (or a long) \code{tibble} showing summary results.
}
\examples{

## requires NONMEM to be installed

\dontrun{

summary_wide(c(m1, m2))
summary_long(c(m1, m2))

}
  
}
