% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-manipulate.R
\name{remove_parameter}
\alias{remove_parameter}
\title{Remove parameter from NONMEM control file}
\usage{
remove_parameter(m, name)
}
\arguments{
\item{m}{An nm object.}

\item{name}{Character. Parameter name to remove.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Attempts to remove a parameter from the NONMEM control assuming it has been
written according to NMproject conventions (i.e. TVPARAM notation and
TVPARAM + IIV_PARAM comments in $THETA/$OMEGA).  The presence of any code
that depends on the removed parameter will cause the control file to break.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))
             
m1 <- m1 \%>\% remove_parameter("KA")

nm_diff(m1)

}
