% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm-gettersetters.R
\name{simple_field}
\alias{simple_field}
\title{Interface for getting and setting your own simple fields in nm objects}
\usage{
simple_field(m, ...)
}
\arguments{
\item{m}{An nm object.}

\item{...}{Arguments to get/set fields.}
}
\value{
If \code{...} contains an assignment, an nm object with modified field,
otherwise returns the field value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 <- m1 \%>\% simple_field(stars = 3)
m1 \%>\% simple_field(stars)
m1 ## see that stars is a field of the nm object.

}
