% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise-covariate.R
\name{test_relations}
\alias{test_relations}
\title{Generate tibble of covariate relations to test}
\usage{
test_relations(dtest, param, cov, state, continuous)
}
\arguments{
\item{dtest}{Optional existing \code{dtest} to append (from an previous use
\code{\link[=test_relations]{test_relations()}}).}

\item{param}{Character. Name of parameter(s).}

\item{cov}{Character. Name of covariate(s).}

\item{state}{Numeric or character. Number/name of state (see details).}

\item{continuous}{Logical (default = \code{TRUE}). If \code{FALSE}, will treat the
covariate as categorical.}
}
\value{
A \code{tibble} describing relationships to test.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The goal of NMproject's covariate modelling functions is to provide a
stepwise covariate method \emph{with manual decision} making.  This important to
ensure that the full model selection/evaluation criteria (should be defined
in statistical analysis plans) can be applied at every step rather than just
log likelihood ratio testing, where the most significant model may be
unstable, may worsen model predictions or may only be slightly more
significant than a more physiologically plausible covariate relationship.

The functions \code{\link[=test_relations]{test_relations()}}, \code{\link[=covariate_step_tibble]{covariate_step_tibble()}},
\code{\link[=bind_covariate_results]{bind_covariate_results()}} together comprise NMproject stepwise covariate
method with manual decision.  The goal is to be part way between PsN's SCM
and completely manual process at each forward and backward elimination step.
The syntax of how covariates are included is the same as PsN's SCM routine -
See \href{https://uupharmacometrics.github.io/PsN/docs.html}{PsN documentation}
for more information.
}
\details{
Setting vector values for \code{param}, \code{cov}, and \code{state}, will expand the grid
to test each value with every other value greedily.  This is similar to
\code{\link[=expand.grid]{expand.grid()}} available states (see also \code{\link[=add_cov]{add_cov()}}):

\describe{

\item{"2" or "linear"}{
PARCOV= ( 1 + THETA(1)*(COV -median))
}

\item{"3" or "hockey-stick"}{
IF(COV.LE.median) PARCOV = ( 1 + THETA(1)*(COV - median))
IF(COV.GT.median) PARCOV = ( 1 + THETA(2)*(COV - median))
}

\item{"4" or "exponential"}{
PARCOV= EXP(THETA(1)*(COV - median))
}

\item{"5" or "power"}{
PARCOV= ((COV/median)**THETA(1))
}

\item{"power1"}{
PARCOV= ((COV/median))
}

\item{"power0.75"}{
PARCOV= ((COV/median)**0.75)
}

\item{"6" or "log-linear"}{
PARCOV= ( 1 + THETA(1)*(LOG(COV) - log(median)))
}

}
}
\examples{

dtest <- test_relations(param = c("KA", "K", "V"),
                        cov = c("LIN1", "LIN2", "LIN3", "RND1", "RND2", "RND3"),
                        state = c("linear", "power"),
                        continuous = TRUE) \%>\%
         test_relations(param = c("KA", "K", "V"),
                        cov = "BN1",
                        state = "linear",
                        continuous = FALSE)

dtest
}
\seealso{
\code{\link[=add_cov]{add_cov()}}, \code{\link[=covariate_step_tibble]{covariate_step_tibble()}}, \code{\link[=bind_covariate_results]{bind_covariate_results()}}
}
