% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{D.LPM}
\alias{D.LPM}
\title{Divergent-Lower Partial Moment
(Lower Right Quadrant 3)}
\usage{
D.LPM(degree.x, degree.y, x, y, target.x = mean(x), target.y = mean(y))
}
\arguments{
\item{degree.x}{integer; Degree for variable X.  \code{(degree.x = 0)} is frequency, \code{(degree.x = 1)} is area.}

\item{degree.y}{integer; Degree for variable Y.  \code{(degree.y = 0)} is frequency, \code{(degree.y = 1)} is area.}

\item{x}{a numeric vector.}

\item{y}{a numeric vector of equal length to \code{x}.}

\item{target.x}{numeric; Typically the mean of Variable X for classical statistics equivalences, but does not have to be. (Vectorized)}

\item{target.y}{numeric; Typically the mean of Variable Y for classical statistics equivalences, but does not have to be. (Vectorized)}
}
\value{
Divergent LPM of two variables
}
\description{
This function generates a divergent lower partial moment between two equal length variables for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
D.LPM(0, 0, x, y, mean(x), mean(y))
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
