% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.grid}
\alias{uTAR.grid}
\title{Search for Threshold Value of A Two-Regime SETAR Model}
\usage{
uTAR.grid(y, p1, p2, d = 1, thrV = NULL, thrQ = c(0, 1),
  Trim = c(0.1, 0.9), include.mean = T)
}
\arguments{
\item{y}{a vector of time series.}

\item{p1, p2}{AR-orders of regime 1 and regime 2.}

\item{d}{delay for threshold variable, default is 1.}

\item{thrV}{threshold variable. if it is not null, thrV must have the same length as that of y.}

\item{thrQ}{lower and upper limits for the possible threshold values.}

\item{Trim}{lower and upper trimming to control the sample size in each regime.}

\item{include.mean}{a logical value for including constant term.}
}
\value{
uTAR.grid returns a list with components:
\item{data}{the data matrix, y.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{residuals}{estimated innovations.}
\item{coefs}{a 2-by-(p+1) matrices. The first row show the estimation results in regime 1, and the second row shows these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{nobs}{numbers of observations in regimes 1 and 2.}
\item{delay}{the delay for threshold variable.}
\item{model1,model2}{estimated models of regimes 1 and 2.}
\item{cnst}{logical values indicating whether the constant terms are included in regimes 1 and 2.}
\item{thr}{threshold value.}
\item{D}{a set of possible threshold values.}
\item{RSS}{residual sum of squares.}
\item{information}{information criterion.}
\item{sresi}{standardized residuals.}
}
\description{
Search for the threshold of a SETAR model for a given range of candidates for threshold values,
and perform recursive LS estimation.
The program uses a grid to search for threshold value.
It is a conservative approach, but might be more reliable than the Li and Tong (2016) procedure.
}
\examples{
arorder=rep(1,2)
ar.coef=matrix(c(0.7,-0.8),2,1)
y=uTAR.sim(100,arorder,ar.coef,1,0)
uTAR.grid(y$series,1,1,1,y$series,c(0,1),c(0.2,0.8),TRUE)
}
\references{
Li, D., and Tong. H. (2016) Nested sub-sample search algorithm for estimation of threshold models. \emph{Statisitca Sinica}, 1543-1554.
}
