% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{thr.test}
\alias{thr.test}
\title{Threshold Nonlinearity Test}
\usage{
thr.test(y, p = 1, d = 1, thrV = NULL, ini = 40, include.mean = T)
}
\arguments{
\item{y}{a time series.}

\item{p}{AR order.}

\item{d}{delay for the threshold variable.}

\item{thrV}{threshold variable.}

\item{ini}{initial number of data to start RLS estimation.}

\item{include.mean}{a logical value for including constant terms.}
}
\value{
\code{thr.test} returns a list with components:
\item{F-ratio}{F statistic.}
\item{df}{the numerator and denominator degrees of freedom.}
\item{ini}{initial number of data to start RLS estimation.}
}
\description{
Threshold nonlinearity test.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))
thr.test(y$series,p=2,d=2,ini=40,include.mean=TRUE)
}
\references{
Tsay, R. (1989) Testing and Modeling Threshold Autoregressive Processes. \emph{Journal of the American Statistical Associations} \strong{84}(405), 231-240.
}
