% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.test.R
\name{PC.test}
\alias{PC.test}
\title{Random shift test of independence between a point process and a covariate}
\usage{
PC.test(X, covariate, N.shifts = 999, radius, correction, verbose = FALSE)
}
\arguments{
\item{X}{point pattern dataset (object of class \code{ppp})}

\item{covariate}{random field (object of class \code{im})}

\item{N.shifts}{integer, how many random shifts should be performed in the random shift test}

\item{radius}{positive real number determining the radius of the disk on which the shift vectors are uniformly distributed}

\item{correction}{which correction should be applied in the random shift test (possible choices are "torus" and "variance")}

\item{verbose}{logical value indicating whether auxiliary information should be printed and auxiliary figures plotted during the computation}
}
\value{
The p-value of the random shift test of independence between a point process and a covariate.
}
\description{
Nonparametric test of independence between a point process and a random field (covariate) based on random shifts, see Dvořák et al. (2022).
Either the torus correction or the variance correction can be used, see Mrkvička et al. (2021).
}
\details{
The test statistic is the mean covariate value observed at the points of the process, see the paper
Dvořák et al. (2022).

The torus correction can be applied for rectangular windows. On the other hand,
the variance correction is applicable both for rectangular and for irregular windows.
The choice of the correction is given by the argument \code{correction}.
Based on the simulation studies in Dvořák et al. (2022),
the variance correction is recommended since it does not exhibit the liberality of the torus correction.

The observed point pattern should be supplied using the
argument \code{X}, the realization of the covariate should be supplied using
the argument \code{covariate}.

The shift vectors are generated from the
uniform distribution on the disk with radius given by the argument \code{radius}
and centered in the origin. The argument \code{verbose} determines if
auxiliary information and plots should be provided.
}
\examples{

library(spatstat)

set.seed(123)

elevation <- bei.extra$elev
plot(elevation)

# tests run with only 99 shifts to speed up the computation
out1 <- PC.test(X=bei, covariate=elevation, N.shifts = 99, radius=250,
                correction="torus", verbose=TRUE)
out1

out2 <- PC.test(X=bei, covariate=elevation, N.shifts = 99, radius=250,
                correction="variance", verbose=TRUE)
out2

}
\references{
J. Dvořák, T. Mrkvička, J. Mateu, J.A. González (2022): Nonparametric testing of the dependence structure among points-marks-covariates in spatial point patterns. International Statistical Review 90(3), 592-621.

T. Mrkvička, J. Dvořák, J.A. González, J. Mateu (2021): Revisiting the random shift approach for testing in spatial statistics. Spatial Statistics 42, 100430.
}
