% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_datatable.R
\name{NasdaqDataLink.datatable.bulk_download_to_file}
\alias{NasdaqDataLink.datatable.bulk_download_to_file}
\title{Downloads a zip with all data requested from a Nasdaq Data Link database}
\usage{
NasdaqDataLink.datatable.bulk_download_to_file(datatable_code, filename, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Nasdaq Data Link specified as a string.}

\item{filename}{Filename (including path) of file to download.}

\item{...}{Additional named values that are interpreted as Nasdaq Data Link API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Downloads a zip with all data requested from a Nasdaq Data Link database
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
NasdaqDataLink.datatable.bulk_download_to_file('ZACKS/EE')
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
