% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_search.R
\name{NasdaqDataLink.search}
\alias{NasdaqDataLink.search}
\title{Search the Nasdaq Data Link database}
\usage{
NasdaqDataLink.search(query, silent = FALSE, per_page = 10, ...)
}
\arguments{
\item{query}{Search terms}

\item{silent}{Prints the results when FALSE.}

\item{per_page}{Number of results returned per page.}

\item{...}{Additional named values that are interpretted as Nasdaq Data Link API parameters.}
}
\value{
Search results returned as a data.frame.
}
\description{
Search the Nasdaq Data Link database
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}

For instructions on finding your authentication token go to https://data.nasdaq.com/account/profile
}
\examples{
\dontrun{
search.results <- NasdaqDataLink.search("oil")
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
