% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_facs.R
\name{sim_facs}
\alias{sim_facs}
\title{Simulate FACS data}
\usage{
sim_facs(m, n_obs = 10, jp = NULL)
}
\arguments{
\item{m}{A matrix with condition as\code{rownames}, elements as
\code{colnames}, and probabilities of observing an element as values.}

\item{n_obs}{Number of observations per condition to simulate}

\item{jp}{An optional list of matrices, the same length as \code{nrow(m)}
with the joint probabilities of elements}
}
\description{
Simulate FACS data
}
\examples{
elements <- as.character(1:10)
conditions <- letters[1:2]
# randomly generate probability of elements
probabilities <-
  sapply(elements, function(x) {
    p <- runif(length(conditions))
    setNames(round(p, 1), nm = conditions)
  })
sim_facs(probabilities)
}
