% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{maxNof}
\alias{maxNof}
\alias{maxNof,matrix,numeric,worldMatrix,missing-method}
\alias{maxNof,matrix,numeric,worldArray,character-method}
\alias{maxNof,agentMatrix,numeric,missing,character-method}
\title{\code{N} \code{agents} with maximum}
\usage{
maxNof(agents, n, world, var)

\S4method{maxNof}{matrix,numeric,worldMatrix,missing}(agents, n, world)

\S4method{maxNof}{matrix,numeric,worldArray,character}(agents, n, world, var)

\S4method{maxNof}{agentMatrix,numeric,missing,character}(agents, n, var)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
              column \code{pycor} representing the \code{patches} coordinates, or

              \code{AgentMatrix} object representing the moving \code{agents}.}

\item{n}{Integer.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a \code{worldArray}
object, \code{var} is the name of the layer to use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is one of
the \code{turtles}' variable and can be equal to \code{xcor},
\code{ycor}, any of the variables created when \code{turtles} were created,
as well as any variable created using \code{turtlesOwn()}.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = \code{n}) with the first column \code{pxcor} and
        the second column \code{pycor} representing the coordinates of the \code{n}
        \code{patches} among the \code{agents} which have their variable values among
        the maximum values among the
        \code{agents}, or

        \code{AgentMatrix} of length \code{n} representing the \code{turtles} among the
        \code{agents} which
        have their \code{var} values among the maximum values among the \code{agents}.
}
\description{
Report the \code{n} \code{patches} or \code{turtles} among \code{agents} which have their variable
among the maximum values.
}
\details{
\code{world} must not be provided if \code{agents} are \code{turtles}.

         If there is a tie that would make the number of returned \code{patches} or \code{turtles} larger
         than \code{n}, it is broken randomly.
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = sample(1:10, size = 25, replace = TRUE))
plot(w1)
p1 <- maxNof(agents = patches(w1), n = 6, world = w1)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:5, size = 10, replace= TRUE))
t2 <- maxNof(agents = t1, n = 5, var = "heading")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#max-n-of}
}
\author{
Sarah Bauduin
}
