% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdLogNormalPareto.R
\name{pSlicedLNormPareto}
\alias{pSlicedLNormPareto}
\title{The cumulative density function (cdf) of a Sliced LogNormal Pareto severity distribution}
\usage{
pSlicedLNormPareto(x, mu, sigma, SlicePoint, shape)
}
\arguments{
\item{x}{A positive real number -  the claim amount where the cumulative density function (cdf) will be evaluated.}

\item{mu}{A real number -  the first parameter of the attritional Claim Severity's LogNormal distribution.}

\item{sigma}{A positive real number -  the second parameter of the attritional Claim Severity's LogNormal distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The value of the cumulative density function (cdf) at \code{x} with an attritional claim LogNormal distribution with parameters \code{mu} and \code{sigma} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{shape}.
}
\description{
The cumulative density function (cdf) of a Sliced LogNormal Pareto severity distribution
}
\examples{
pSlicedLNormPareto(1200,6,1.5,1000,1.2)
pSlicedLNormPareto(4000,7,1.6,3000,1.4)
}
