% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_gdd.R
\name{nd.gdd}
\alias{nd.gdd}
\title{Graph Diffusion Distance}
\usage{
nd.gdd(A, out.dist = TRUE, vect = seq(from = 0.1, to = 1, length.out =
  10))
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{vect}{a vector of parameters \eqn{t} whose values will be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{maxt}{an \eqn{(N\times N)} matrix whose entries are maximizer of the cost function.}
}
}
\description{
Graph Diffusion Distance (\code{nd.gdd}) quantifies the difference between two weighted graphs of same size. It takes
an idea from heat diffusion process on graphs via graph Laplacian exponential kernel matrices. For a given
adjacency matrix \eqn{A}, the graph Laplacian is defined as
\deqn{L := D-A}
where \eqn{D_{ii}=\sum_j A_{ij}}. For two adjacency matrices \eqn{A_1} and \eqn{A_2},
GDD is defined as
\deqn{d_{gdd}(A_1,A_2) = max_t \sqrt{\| \exp(-tL_1) -\exp(-tL_2)   \|_F^2}}
where \eqn{\exp(\cdot)} is matrix exponential, \eqn{\|\cdot\|_F} a Frobenius norm, and \eqn{L_1} and \eqn{L_2}
Laplacian matrices corresponding to \eqn{A_1} and \eqn{A_2}, respectively.
}
\examples{
\dontrun{
## generate two types of adjacency matrices of size (3-by-3)
rbin1 = rbinom(9,1,0.8); mat1 = matrix(rbin1,nrow=3)
rbin2 = rbinom(9,1,0.2); mat2 = matrix(rbin2,nrow=3)

mattype1 = ceiling((mat1+t(mat1))/2); diag(mattype1)=0;
mattype2 = ceiling((mat2+t(mat2))/2); diag(mattype2)=0;

A = list()
for (i in 1:3){A[[i]]=mattype1} # first 3 are type-1
for (i in 4:6){A[[i]]=mattype2} # next  3 are type-2

## Compute Distance Matrix and Visualize
output = nd.gdd(A)
image(as.matrix(output$D), main="two group case")
}

}
\references{
\insertRef{hammond_graph_2013}{NetworkDistance}
}
