% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_extremal.R
\name{nd.extremal}
\alias{nd.extremal}
\title{Extremal distance with top-\eqn{k} eigenvalues}
\usage{
nd.extremal(A, out.dist = TRUE, k = ceiling(nrow(A)/5))
}
\arguments{
\item{A}{a list of length \code{N} containing adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{k}{the number of largest eigenvalues to be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times k)} matrix where each row is top-\eqn{k} Laplacian eigenvalues.}
}
}
\description{
Extremal distance (\code{nd.extremal}) is a type of spectral distance measures on two graphs' graph Laplacian,
\deqn{L := D-A}
where \eqn{A} is an adjacency matrix and \eqn{D_{ii}=\sum_j A_{ij}}. It takes top-\eqn{k} eigenvalues from
graph Laplacian matrices and take normalized sum of squared differences as metric. Note that it is
\emph{1. non-negative}, \emph{2. separated}, \emph{3. symmetric}, and satisfies \emph{4. triangle inequality} in that
it is indeed a metric.
}
\examples{
\dontrun{
## load data
data(graph20)

## Compute Distance Matrix and Visualize
output = nd.extremal(graph20, out.dist=FALSE, k=2)
par(pty="s")
image(output$D[,20:1], main="two group case", col=gray(0:32/32), axes=FALSE)
}

}
\references{
\insertRef{jakobson_extremal_2002}{NetworkDistance}
}
